package com.xebialabs.xlplatform.webhooks.events.handlers

import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventProcessor}
import grizzled.slf4j.Logging

trait EventProcessorHandler[IN <: Event, OUT <: Event, P <: EventProcessor]
  extends EventConsumerHandler[IN, P] with EventSourceHandler[OUT, P] {
  self: Logging =>

  def map(config: P, event: IN): OUT

  def process(config: P, event: IN): Option[OUT] = {
    logger.debug(s"eventProc: process($config, $event)")
    Option(map(config, event)).map { output =>
      output.setSourceId(config.sourceId)
      output
    }
  }

  def consumeEvent(config: P, event: IN): Boolean = {
    logger.trace(s"eventProc: consumeEvent($config, $event)")
    process(config, event).exists(publish(config, _))
  }

}
