package com.xebialabs.xlrelease.webhooks.configuration.jms


import org.apache.activemq.ActiveMQConnectionFactory
import org.apache.activemq.command.ActiveMQQueue

import jakarta.jms.{ConnectionFactory, Destination}

class EmbeddedActiveMqWebhookJmsConfiguration(config: EmbeddedActiveMqWebhookQueueConfig)
  extends BasicWebhookJmsConfiguration {

  override def jmsConnectionFactory: ConnectionFactory = {
    val activeMQConnectionFactory = new ActiveMQConnectionFactory
    activeMQConnectionFactory.setBrokerURL("vm://embedded-broker?broker.persistent=false&broker.useShutdownHook=false")
    activeMQConnectionFactory.setTrustAllPackages(true)
    activeMQConnectionFactory
  }

  override def webhookEventQueue: Destination = {
    new ActiveMQQueue(config.queueName)
  }

}
