package com.xebialabs.xlrelease.webhooks.cleanup

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.webhooks.cleanup.EventRecordCleanupQuartzJob.REQUEST_RETENTION
import com.xebialabs.xlrelease.webhooks.endpoint.WebhookEndpoint
import com.xebialabs.xlrelease.webhooks.repository.persistence.CiEventRecordsPersistence
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

object EventRecordCleanupQuartzJob {
  val REQUEST_RETENTION = "requestRetention"
}

@DisallowConcurrentExecution
class EventRecordCleanupQuartzJob extends Job with Logging {

  @Autowired
  var eventRecordsPersistence: CiEventRecordsPersistence = _

  @Autowired
  var configurationRepository: ConfigurationRepository = _

  @Autowired
  var configurationPersistence: ConfigurationPersistence = _

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing webhook request cleanup job")
    Try {
      for {
        endpoint <- configurationRepository.findAllByType[WebhookEndpoint](Type.valueOf(classOf[WebhookEndpoint])).asScala
        endpointUid = configurationPersistence.getUid(endpoint.getId).getOrElse(0.asInstanceOf[CiUid])
        requestsToRetain = Option(endpoint.getProperty[Int](REQUEST_RETENTION)).getOrElse(100)
      } yield eventRecordsPersistence.deleteRecordsByUuid(endpointUid, requestsToRetain)
    } match {
      case Failure(ex) => logger.error(s"Webhook request cleanup aborted due to an exception", ex)
      case Success(_) => logger.info(s"Webhook request cleanup finished")
    }
  }
}
