package com.xebialabs.xlrelease.webhooks.authentication

import com.xebialabs.platform.script.jython.{JythonException, ScriptSource}
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod
import com.xebialabs.xlplatform.webhooks.domain.Endpoint
import com.xebialabs.xlrelease.webhooks.utils.JythonScriptEventProcessingUtils
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util
import scala.util.Try

@Component
class JythonScriptAuthenticationMethod @Autowired()(jythonScriptUtils: JythonScriptEventProcessingUtils) extends RequestAuthenticationMethod with Logging {

  JythonScriptAuthenticationMethod.init(this)

  import jythonScriptUtils._

  override def authenticate(endpoint: Endpoint,
                            headers: util.Map[String, String],
                            params: util.Map[String, Array[String]],
                            payload: String): Boolean = {

    val config: JythonScriptAuthentication =
      endpoint.authentication.asInstanceOf[JythonScriptAuthentication]

    Try {
      val scriptSource = ScriptSource.byContent(config.authenticationScript)

      executeAuthentication(config, endpoint, headers, params, payload, sandbox = true)
        .apply(logger)
        .apply(scriptSource)
    }.recover {
      case ex: JythonException =>
        logger.warn(ex.getMessage, ex.getCause)
        false
    }.get
  }

}

object JythonScriptAuthenticationMethod {
  private var instance: JythonScriptAuthenticationMethod = _

  def getInstance(): JythonScriptAuthenticationMethod = {
    if (instance == null) {
      throw new IllegalStateException("getInstance called earlier than being initialized, " +
        "check, that your REST controller or test class has @Autorwired " +
        "JythonScriptAuthenticationMethod or " +
        "List[RequestAuthenticationMethod]")
    }
    instance
  }

  def init(jythonScriptAuthenticationMethod: JythonScriptAuthenticationMethod): Unit = {
    if (jythonScriptAuthenticationMethod == null) {
      throw new IllegalArgumentException("Attempt to initialize with null")
    }
    instance = jythonScriptAuthenticationMethod
  }
}
