package com.xebialabs.xlplatform.webhooks.endpoint

import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod
import com.xebialabs.xlplatform.webhooks.domain.Endpoint

import scala.util.{Failure, Success, Try}

trait AuthenticationMethodSupport {
  def getRequestAuthenticationMethod(endpoint: Endpoint): Try[RequestAuthenticationMethod] = {
    val authenticationMethod = for {
      auth <- Option(endpoint.authentication)
      method <- Option(auth.requestAuthentication)
    } yield method
    authenticationMethod
      .toRight(exceptions.EndpointAuthenticationMethodNotFound(endpoint))
      .toTry
  }

  def authenticateRequest(
                          endpoint: Endpoint,
                          headers: Map[String, String],
                          params: Map[String, Array[String]],
                          payload: String)
                         (authenticationMethod: RequestAuthenticationMethod): Try[Unit] =
    if (authenticationMethod.authenticateScala(endpoint, headers, params, payload)) {
      Success(())
    } else {
      Failure(exceptions.UnauthorizedRequest(endpoint, authenticationMethod))
    }
}
