package com.xebialabs.xlrelease.webhooks.authentication

import com.xebialabs.platform.script.jython.{JythonException, ScriptSource}
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod
import com.xebialabs.xlplatform.webhooks.domain.Endpoint
import com.xebialabs.xlrelease.webhooks.utils.JythonScriptEventProcessingUtils
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util
import scala.util.Try

@Component
class CustomJythonAuthenticationMethod @Autowired()(jythonScriptUtils: JythonScriptEventProcessingUtils) extends RequestAuthenticationMethod with Logging {

  CustomJythonAuthenticationMethod.init(this)

  import jythonScriptUtils._

  override def authenticate(endpoint: Endpoint,
                            headers: util.Map[String, String],
                            params: util.Map[String, Array[String]],
                            payload: String): Boolean = {

    val config: CustomJythonAuthentication =
      endpoint.authentication.asInstanceOf[CustomJythonAuthentication]

    Try {
      val scriptSource = ScriptSource.byResource(scriptLocationOrDefault(config.getType, config.scriptLocation))

      executeAuthentication(config, endpoint, headers, params, payload, sandbox = false)
        .apply(logger)
        .apply(scriptSource)
    }.recover {
      case ex: JythonException =>
        logger.warn(ex.getMessage, ex.getCause)
        false
    }.get
  }

}

object CustomJythonAuthenticationMethod {
  private var instance: CustomJythonAuthenticationMethod = _

  def getInstance(): CustomJythonAuthenticationMethod = {
    if (instance == null) {
      throw new IllegalStateException("getInstance called earlier than being initialized, " +
        "check, that your REST controller or test class has @Autorwired " +
        "CustomJythonAuthenticationMethod or " +
        "List[RequestAuthenticationMethod]")
    }
    instance
  }

  def init(customJythonAuthenticationMethod: CustomJythonAuthenticationMethod): Unit = {
    if (customJythonAuthenticationMethod == null) {
      throw new IllegalArgumentException("Attempt to initialize with null")
    }
    instance = customJythonAuthenticationMethod
  }
}
