package com.xebialabs.xlrelease.webhooks.configuration

import com.jayway.jsonpath
import com.jayway.jsonpath.Configuration
import com.jayway.jsonpath.spi.cache.{CacheProvider, NOOPCache}
import com.jayway.jsonpath.spi.json.{JacksonJsonProvider, JsonProvider}
import com.jayway.jsonpath.spi.mapper.{JacksonMappingProvider, MappingProvider}
import org.springframework.context.annotation.Bean

import java.util
import scala.util.Try

@org.springframework.context.annotation.Configuration
class JsonPathConfiguration {

  @Bean
  def configuration: Configuration = {
    Configuration.setDefaults(new Configuration.Defaults {
      val provider = new JacksonJsonProvider()
      val mapper = new JacksonMappingProvider()

      override def jsonProvider(): JsonProvider = provider

      override def options(): util.Set[jsonpath.Option] = java.util.EnumSet.noneOf(classOf[jsonpath.Option])

      override def mappingProvider(): MappingProvider = mapper
    })

    Try(CacheProvider.setCache(new NOOPCache)) // no need for cache currently

    Configuration.defaultConfiguration()
  }

  @Bean
  def jsonProvider(configuration: Configuration): JsonProvider = configuration.jsonProvider()

}
