package com.xebialabs.xlplatform.webhooks.events.handlers

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry
import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventConsumer}
import grizzled.slf4j.Logging


trait EventConsumerHandler[E <: Event, -C <: EventConsumer] {
  self: Logging =>

  def consumeEvent(config: C, event: E): Boolean

  def filter(config: C, event: E): Boolean = true

  def consume(config: C, event: E): Boolean = {
    logger.debug(s"consume($config, $event)")
    logger.trace(s"subtypes of event.getType (${event.getType}): ${DescriptorRegistry.getSubtypes(event.getType)}")
    logger.trace(s"subtypes of config.inputType (${config.inputType}): ${DescriptorRegistry.getSubtypes(config.inputType)}")
    if (config.consumerEnabled) {
      if (config.inputType == null || event.getType.instanceOf(config.inputType)) {
        if (filter(config, event)) {
          logger.trace("types check, consumeEvent()")
          consumeEvent(config, event)
        } else {
          logger.trace("filter returned false, ignoring event")
          false
        }
      } else {
        logger.warn(s"types mismatch on consumer ${config.consumerId}, expected ${config.inputType}, got ${event.getType}")
        false
      }
    } else {
      logger.trace(s"consumer ${config.consumerId} disabled, ignoring event ${event.getId}")
      false
    }
  }
}
