package com.xebialabs.xlrelease.webhooks.consumers.logging

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.webhooks.consumers.BaseConsumerHandler
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class LoggingConsumerHandler @Autowired()(val eventBus: XLReleaseEventBus,
                                          subscriberRegistry: SubscriberRegistry)
  extends BaseConsumerHandler[SpyConsumer] {

  override def consumeEvent(config: SpyConsumer, event: Event): Boolean = {
    eventBus.publish(
      JmsDispatcherEvent(
        s"sourceId: ${event.sourceId}",
        s" event: ${event.getType}"
      ))
    true
  }

  override def consumerConfigType: Type = Type.valueOf(classOf[SpyConsumer])

}
