package com.xebialabs.xlplatform.webhooks.queue.configuration

import jakarta.jms.ConnectionFactory
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl
import org.apache.activemq.artemis.core.server.ActiveMQServers
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory
import org.springframework.jms.config.DefaultJmsListenerContainerFactory
import org.springframework.jms.connection.CachingConnectionFactory
import org.springframework.jms.core.JmsTemplate

class EmbeddedQueueConfiguration() extends AbstractQueueConfiguration {

  private lazy val artemisMQConnectionFactory: ActiveMQConnectionFactory = {
    startArtemisServer()
    new ActiveMQConnectionFactory("vm://0")
  }

  override def jmsConnectionFactory: ConnectionFactory = artemisMQConnectionFactory

  override def jmsTemplate: JmsTemplate = {
    new JmsTemplate(new CachingConnectionFactory(artemisMQConnectionFactory))
  }

  override def jmsListenerContainerFactory: DefaultJmsListenerContainerFactory = {
    val factory = new DefaultJmsListenerContainerFactory()
    // This provides all boot's default to this factory, including the message converter
    factory.setConnectionFactory(artemisMQConnectionFactory)
    // You could still override some of Boot's default if necessary.
    factory
  }

  private def startArtemisServer(): Unit = {
    val server = ActiveMQServers.newActiveMQServer(new ConfigurationImpl()
      .setPersistenceEnabled(false)
      .setSecurityEnabled(false)
      .addAcceptorConfiguration("invm", "vm://0"));
    server.start()
  }
}
