package com.xebialabs.xlrelease.webhooks.task

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlplatform.webhooks.events.domain.EventConsumer
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.repository.Ids.SEPARATOR
import com.xebialabs.xlrelease.webhooks.consumers.BaseConsumer.CONSUMER_ID_SUFFIX

case class ReactiveTaskConsumer(taskId: String) extends BaseConfigurationItem with EventConsumer {

  def this() = this("")

  def this(task: Task) = this(task.getId)

  Option(taskId).foreach { id =>
    setId(id + SEPARATOR + CONSUMER_ID_SUFFIX)
  }

  setInputEventType(EVENT_TYPE.toString)
  setConsumerEnabled(true)
}