package com.xebialabs.xlplatform.webhooks.queue.configuration

import com.typesafe.config.Config
import com.xebialabs.deployit.security.SecretKeyHolder
import com.xebialabs.xlplatform.config.ConfigLoader

case class JmsQueueConfig(embedded: Boolean, url: String, username: String, password: String, queueName: String)

object JmsQueueConfig {

  def newInstance(configName: String, secretKeyHolder: SecretKeyHolder = SecretKeyHolder.get()): JmsQueueConfig = {
    fromConfig(ConfigLoader.loadSecuredWithDynamic(configName, secretKeyHolder).getConfig("xl"))
  }

  def fromConfig(config: Config): JmsQueueConfig = {
    val conf = config.getConfig("queue")
    val queueConfig = JmsQueueConfig(
      conf.getBoolean("embedded"),
      conf.getString("url"),
      conf.getString("username"),
      conf.getString("password"),
      conf.getString("queueName")
    )
    queueConfig
  }
}
