package com.xebialabs.xlplatform.webhooks.queue.configuration

import grizzled.slf4j.Logging
import org.springframework.context.annotation.Bean
import org.springframework.jms.config.DefaultJmsListenerContainerFactory
import org.springframework.jms.core.JmsTemplate
import org.springframework.jms.support.converter.MessageConverter

import javax.jms.ConnectionFactory


// TODO: maybe make this a trait and ask product to implement it, setting a specific confFile name? or maybe there's a better way abstracting "xl-release.conf" already!
// TODO: remove logging

class QueueConfiguration(config: JmsQueueConfig) extends AbstractQueueConfiguration with Logging {

  private lazy val queueConfigurationInstance: AbstractQueueConfiguration = {
    if (config.embedded) {
      new EmbeddedQueueConfiguration
    } else {
      new StandaloneQueueConfiguration
    }
  }

  @Bean
  lazy val converter: MessageConverter = EventMessageConverter

  @Bean
  override def jmsTemplate: JmsTemplate = {
    val template = queueConfigurationInstance.jmsTemplate
    template.setMessageConverter(converter)
    template
  }

  @Bean
  override def jmsConnectionFactory: ConnectionFactory = {
    queueConfigurationInstance.jmsConnectionFactory
  }

  @Bean
  override def jmsListenerContainerFactory: DefaultJmsListenerContainerFactory = {
    val factory = queueConfigurationInstance.jmsListenerContainerFactory
    // seems this has no effect on JmsTemplate ?
    factory.setMessageConverter(converter)
    factory.setAutoStartup(false)
    factory
  }

}
