package com.xebialabs.xlrelease.webhooks.authentication

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod

@Metadata(virtual = false, label = "Token Authentication")
class TokenAuthentication extends BaseRequestAuthentication {

  @Property(label = "Secret Token", password = true, required = true,
    description = "Secret token that will be passed in x-release-webhook-token request header")
  var webhookToken: String = _

  def requestAuthentication: RequestAuthenticationMethod = TokenAuthenticationMethod
}
