package com.xebialabs.xlplatform.webhooks.endpoint

import com.xebialabs.xlplatform.webhooks.domain.Endpoint
import com.xebialabs.xlplatform.webhooks.endpoint.exceptions.EndpointDisabled

import javax.servlet.http.HttpServletRequest
import scala.util.{Failure, Success, Try}

trait EndpointValidator {
  protected def checkEnabled(endpoint: Endpoint): Try[Unit] =
    if (!endpoint.sourceEnabled) {
      Failure(EndpointDisabled(endpoint))
    } else {
      Success(())
    }

  protected def checkMethod(request: HttpServletRequest, endpoint: Endpoint): Try[Unit] =
    if (endpoint.method.name() != request.getMethod) {
        Failure(exceptions.WrongMethod(request, endpoint))
    }
    else {
      Success(())
    }

}
