package com.xebialabs.xlrelease.webhooks.cleanup

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_JOB_SCHEDULER
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent
import com.xebialabs.xlrelease.utils.QuartzUtils._
import com.xebialabs.xlrelease.webhooks.cleanup.EventRecordCleanupService.{CLEANUP_SERVICE_NAME, GROUP_NAME, JOB_NAME}
import grizzled.slf4j.Logging
import org.quartz.CronScheduleBuilder.cronSchedule
import org.quartz.JobBuilder.newJob
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{CronTrigger, JobDetail, Scheduler}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.context.event
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class EventRecordCleanupService @Autowired()(@Qualifier(BEAN_QUARTZ_JOB_SCHEDULER) val scheduler: Scheduler,
                                             xlrConfig: XlrConfig) extends Logging {

  private lazy val job: JobDetail = newJob(classOf[EventRecordCleanupQuartzJob])
    .withDescription(s"$CLEANUP_SERVICE_NAME job")
    .withIdentity(JOB_NAME, GROUP_NAME)
    .build()

  private lazy val trigger: CronTrigger = newTrigger()
    .withIdentity(JOB_NAME, GROUP_NAME)
    .withDescription(s"Trigger $CLEANUP_SERVICE_NAME jobs")
    .withSchedule(
      cronSchedule(xlrConfig.features.webhooks.retentionPolicy.schedule.asQuartzCron)
        .withMisfireHandlingInstructionDoNothing()
    )
    .startNow()
    .build()

  private def schedule(): Unit = {
    logger.debug(s"Schedule $CLEANUP_SERVICE_NAME job")
    if (scheduler.checkExists(trigger.getKey)) {
      scheduler.rescheduleJob(trigger.getKey, trigger)
    } else {
      scheduler.scheduleJob(job, Set(trigger).asJava, true)
    }
  }

  @event.EventListener
  def onStartup(event: SchedulerStartedEvent): Unit = {
    try {
      schedule()
    } catch {
      case e: Exception => logger.error(s"Error while starting $CLEANUP_SERVICE_NAME service", e)
    }
  }
}

object EventRecordCleanupService {
  val CLEANUP_SERVICE_NAME = "Event Record Cleanup"
  val JOB_NAME = "EVENT_RECORD_CLEANUP_JOB"
  val GROUP_NAME = "CLEANUP"
}

