package com.xebialabs.xlrelease.webhooks.endpoint

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlplatform.webhooks.domain.EndpointHttpMethod

@WebhookEndpointRule
@Metadata(
  label = "HTTP Endpoint for Webhooks",
  virtual = true)
abstract class WebhookEndpoint extends AuthenticationWebhookEndpoint {
  override def toString: String = s"${super.toString} ($getTitle)"
}

object WebhookEndpoint {
  @Metadata(label = "POST Endpoint", virtual = false)
  class PostWebhookEndpoint extends WebhookEndpoint {
    method = EndpointHttpMethod.POST
  }

  @Metadata(label = "GET Endpoint", virtual = false)
  class GetWebhookEndpoint extends WebhookEndpoint {
    method = EndpointHttpMethod.GET
  }

}

