package com.xebialabs.xlrelease.webhooks.task

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.actors.initializer.SubscriptionInitializer
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.PythonScript
import com.xebialabs.xlrelease.domain.status.TaskStatus
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.{TaskPersistence, TasksSqlBuilder}
import com.xebialabs.xlrelease.repository.{Ids, ReleaseRepository}
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions
import com.xebialabs.xlrelease.utils.TypeHelper.getAllSubtypesOf
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._
import scala.util.Try

@Component
class RestoreReactiveTaskSubscriberRegistry @Autowired()(val subscriberRegistry: SubscriberRegistry,
                                                         val taskPersistence: TaskPersistence,
                                                         val releaseRepository: ReleaseRepository,
                                                         @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect)
  extends ReactiveTaskSubscriber with SubscriptionInitializer {

  override def initialize(): Unit = {
    for {
      taskId <- findActiveReactiveTasks()
      release <- Try(releaseRepository.findById(Ids.releaseIdFrom(taskId), ResolveOptions.REFERENCES)).toOption
      task <- release.getAllTasks.asScala if task.getId.endsWith(taskId)
      if isReactiveTask(task)
    } {
      register(task)
    }
  }

  private def findActiveReactiveTasks(): Seq[CiId] = {
    val builder = new TasksSqlBuilder()
    builder.withOneOfTaskStatuses(Seq(TaskStatus.IN_PROGRESS))
    builder.withTaskTypes(getAllSubtypesOf(REACTIVE_TASK_TYPE) ++ getAllSubtypesOf(Type.valueOf(classOf[PythonScript])).filter(isImplicitReactive))
    builder.selectTaskId()
    val sqlWithParams = builder.build()
    taskPersistence.findTaskIdsByQuery(sqlWithParams)
  }

}
