package com.xebialabs.xlrelease.webhooks.endpoint

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlplatform.webhooks.domain.{Endpoint, EndpointHttpMethod}
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.webhooks.authentication.BaseRequestAuthentication

@WebhookEndpointRule
@Metadata(
  label = "HTTP Endpoint for Webhooks",
  virtual = true)
abstract class WebhookEndpoint extends BaseSource with Endpoint {

  override type RequestAuthenticationType = BaseRequestAuthentication

  override def setId(id: String): Unit = {
    super.setId(id)
    if (authentication != null) {
      authentication.setId(id + Ids.SEPARATOR + BaseRequestAuthentication.AUTHENTICATION_ID_SUFFIX)
    }
  }

  override def toString: String = s"${super.toString} ($getTitle)"
}

object WebhookEndpoint {
  @Metadata(label = "POST Endpoint", virtual = false)
  class PostWebhookEndpoint extends WebhookEndpoint {
    method = EndpointHttpMethod.POST
  }

  @Metadata(label = "GET Endpoint", virtual = false)
  class GetWebhookEndpoint extends WebhookEndpoint {
    method = EndpointHttpMethod.GET
  }

}

