/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.udm.reporting.repository.sql;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.udm.reporting.Deployment;
import com.xebialabs.xlrelease.udm.reporting.DeploymentAction;
import com.xebialabs.xlrelease.udm.reporting.DeploymentHistory;
import com.xebialabs.xlrelease.udm.reporting.DeploymentStatus;
import com.xebialabs.xlrelease.udm.reporting.repository.DeploymentRepository;
import com.xebialabs.xlrelease.udm.reporting.repository.sql.DeploymentsSqlBuilder;
import com.xebialabs.xlrelease.udm.reporting.repository.sql.persistence.DeploymentHistoryPersistence;
import com.xebialabs.xlrelease.udm.reporting.repository.sql.persistence.DeploymentPersistence;
import java.util.Date;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Repository
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001E\u0011qcU9m\t\u0016\u0004Hn\\=nK:$(+\u001a9pg&$xN]=\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u000be\u0016\u0004xn]5u_JL(BA\u0004\t\u0003%\u0011X\r]8si&twM\u0003\u0002\n\u0015\u0005\u0019Q\u000fZ7\u000b\u0005-a\u0011!\u0003=me\u0016dW-Y:f\u0015\tia\"A\u0005yK\nL\u0017\r\\1cg*\tq\"A\u0002d_6\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005!\u0011BA\u000e\u0005\u0005Q!U\r\u001d7ps6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\"AQ\u0004\u0001B\u0001B\u0003%a$A\u000beKBdw._7f]R\u0004VM]:jgR,gnY3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0011a\u00039feNL7\u000f^3oG\u0016L!a\t\u0011\u0003+\u0011+\u0007\u000f\\8z[\u0016tG\u000fU3sg&\u001cH/\u001a8dK\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\u000feKBdw._7f]RD\u0015n\u001d;pef\u0004VM]:jgR,gnY3\u0011\u0005}9\u0013B\u0001\u0015!\u0005q!U\r\u001d7ps6,g\u000e\u001e%jgR|'/\u001f)feNL7\u000f^3oG\u0016D\u0001B\u000b\u0001\u0003\u0006\u0004%\u0019aK\u0001\bI&\fG.Z2u+\u0005a\u0003CA\u0017A\u001d\tqSH\u0004\u00020w9\u0011\u0001'\u000f\b\u0003car!AM\u001c\u000f\u0005M2T\"\u0001\u001b\u000b\u0005U\u0002\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tia\"\u0003\u0002\f\u0019%\u0011!HC\u0001\u0003I\nL!a\u0001\u001f\u000b\u0005iR\u0011B\u0001 @\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003\u0007qJ!!\u0011\"\u0003\u000f\u0011K\u0017\r\\3di*\u0011ah\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005Y\u0005AA-[1mK\u000e$\b\u0005C\u0003G\u0001\u0011\u0005q)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0011*[E\n\u0005\u0002J\u00015\t!\u0001C\u0003\u001e\u000b\u0002\u0007a\u0004C\u0003&\u000b\u0002\u0007a\u0005C\u0003+\u000b\u0002\u000fA\u0006\u000b\u0003M\u001drk\u0006CA([\u001b\u0005\u0001&BA)S\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003'R\u000bqAZ1di>\u0014\u0018P\u0003\u0002V-\u0006)!-Z1og*\u0011q\u000bW\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011,A\u0002pe\u001eL!a\u0017)\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%\u00010\u0002'I,\u0007o\u001c:uS:<7+\u001d7ES\u0006dWm\u0019;\t\u000b\u0001\u0004A\u0011I1\u0002\r\r\u0014X-\u0019;f)\t\u0011W\r\u0005\u0002\u0014G&\u0011A\r\u0006\u0002\u0005+:LG\u000fC\u0003g?\u0002\u0007q-\u0001\u0006eKBdw._7f]R\u0004\"\u0001[5\u000e\u0003\u0019I!A\u001b\u0004\u0003\u0015\u0011+\u0007\u000f\\8z[\u0016tG\u000fC\u0003m\u0001\u0011\u0005S.\u0001\u0004va\u0012\fG/\u001a\u000b\u0004E:\u0004\b\"B8l\u0001\u00049\u0017\u0001C8sS\u001eLg.\u00197\t\u000bE\\\u0007\u0019A4\u0002\u000fU\u0004H-\u0019;fI\")1\u000f\u0001C!i\u00061A-\u001a7fi\u0016$\"AY;\t\u000bY\u0014\b\u0019A<\u0002\u0019\u0011,\u0007\u000f\\8z[\u0016tG/\u00133\u0011\u0005adhBA={!\t\u0019D#\u0003\u0002|)\u00051\u0001K]3eK\u001aL!! @\u0003\rM#(/\u001b8h\u0015\tYH\u0003C\u0004\u0002\u0002\u0001!\t%a\u0001\u0002\r\u0015D\u0018n\u001d;t)\u0011\t)!a\u0003\u0011\u0007M\t9!C\u0002\u0002\nQ\u0011qAQ8pY\u0016\fg\u000eC\u0003w\u007f\u0002\u0007q\u000fC\u0004\u0002\u0010\u0001!\t%!\u0005\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$B!a\u0005\u0002\u001aA!1#!\u0006h\u0013\r\t9\u0002\u0006\u0002\u0007\u001fB$\u0018n\u001c8\t\rY\fi\u00011\u0001x\u0011\u001d\ti\u0002\u0001C!\u0003?\tABZ5oI\nKH+Y:l\u0013\u0012$B!!\t\u00024A)\u00111EA\u0017O:!\u0011QEA\u0015\u001d\r\u0019\u0014qE\u0005\u0002+%\u0019\u00111\u0006\u000b\u0002\u000fA\f7m[1hK&!\u0011qFA\u0019\u0005\r\u0019V-\u001d\u0006\u0004\u0003W!\u0002bBA\u001b\u00037\u0001\ra^\u0001\u0007i\u0006\u001c8.\u00133\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u0005ya-\u001b8e\u0011&\u001cHo\u001c:z\u0005fLE\r\u0006\u0003\u0002>\u0005\u0015\u0003CBA\u0012\u0003[\ty\u0004E\u0002i\u0003\u0003J1!a\u0011\u0007\u0005E!U\r\u001d7ps6,g\u000e\u001e%jgR|'/\u001f\u0005\u0007m\u0006]\u0002\u0019A<\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L\u0005qB-\u001a7fi\u0016\fU\u000f^8HK:,'/\u0019;fI\u0012+\u0007\u000f\\8z[\u0016tGo\u001d\u000b\u0004E\u00065\u0003bBA\u001b\u0003\u000f\u0002\ra\u001e\u0015\u0013\u0001\u0005EC,a\u0018\u0002d\u0005\u0015\u0014qNA9\u0003w\ni\b\u0005\u0003\u0002T\u0005mSBAA+\u0015\r\t\u0016q\u000b\u0006\u0004\u000332\u0016a\u0003;sC:\u001c\u0018m\u0019;j_:LA!!\u0018\u0002V\tiAK]1og\u0006\u001cG/[8oC2\f#!!\u0019\u00027I,\u0007o\u001c:uS:<GK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0003-\u0001(o\u001c9bO\u0006$\u0018n\u001c8%\u0005\u0005\u001d\u0014\u0002BA5\u0003W\n\u0001BU#R+&\u0013V\t\u0012\u0006\u0005\u0003[\n)&A\u0006Qe>\u0004\u0018mZ1uS>t\u0017!C5t_2\fG/[8oI\t\t\u0019(\u0003\u0003\u0002v\u0005]\u0014A\u0004*F\u0003\u0012{6iT'N\u0013R#V\t\u0012\u0006\u0005\u0003s\n)&A\u0005Jg>d\u0017\r^5p]\u0006Y!o\u001c7mE\u0006\u001c7NR8sY\t\tyh\t\u0002\u0002\u0002B!\u00111EAB\u0013\u0011\t))!\r\u0003\u0013QC'o\\<bE2,\u0007f\u0001\u0001\u0002\nB!\u00111RAI\u001b\t\tiIC\u0002\u0002\u0010Z\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\u0019*!$\u0003\u0015I+\u0007o\\:ji>\u0014\u0018\u0010")
public class SqlDeploymentRepository
implements DeploymentRepository {
    private final DeploymentPersistence deploymentPersistence;
    private final DeploymentHistoryPersistence deploymentHistoryPersistence;
    private final SqlBuilder.Dialect dialect;

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public void create(Deployment deployment) {
        this.deploymentPersistence.insert(deployment);
        DeploymentHistory history = new DeploymentHistory();
        history.setDeploymentId(deployment.getDeploymentId());
        history.setOldStatus(deployment.getStatus());
        history.setNewStatus(deployment.getStatus());
        history.setChangeDate(new Date());
        history.setAction(DeploymentAction.fromStatus(null, deployment.getStatus()));
        history.setTaskOwner(deployment.getTaskOwner());
        history.setTaskTeam(deployment.getTaskTeam());
        this.deploymentHistoryPersistence.insert(history);
    }

    @Override
    public void update(Deployment original, Deployment updated) {
        block0: {
            this.deploymentPersistence.update(updated);
            DeploymentStatus deploymentStatus = original.getStatus();
            DeploymentStatus deploymentStatus2 = updated.getStatus();
            if (!(deploymentStatus == null ? deploymentStatus2 != null : !((Object)((Object)deploymentStatus)).equals((Object)deploymentStatus2))) break block0;
            DeploymentHistory history = new DeploymentHistory();
            history.setDeploymentId(updated.getDeploymentId());
            history.setOldStatus(original.getStatus());
            history.setNewStatus(updated.getStatus());
            history.setChangeDate(new Date());
            history.setAction(DeploymentAction.fromStatus(original.getStatus(), updated.getStatus()));
            history.setTaskOwner(updated.getTaskOwner());
            history.setTaskTeam(updated.getTaskTeam());
            this.deploymentHistoryPersistence.insert(history);
        }
    }

    @Override
    public void delete(String deploymentId) {
        this.deploymentPersistence.delete(deploymentId);
    }

    @Override
    public boolean exists(String deploymentId) {
        return this.deploymentPersistence.exists(deploymentId);
    }

    @Override
    public Option<Deployment> findById(String deploymentId) {
        return this.deploymentPersistence.findById(deploymentId);
    }

    @Override
    public Seq<Deployment> findByTaskId(String taskId) {
        Tuple2 query = new DeploymentsSqlBuilder(this.dialect()).withTaskId(taskId).build();
        return this.deploymentPersistence.findByQuery((Tuple2<String, Seq<Object>>)query);
    }

    @Override
    public Seq<DeploymentHistory> findHistoryById(String deploymentId) {
        return this.deploymentHistoryPersistence.findById(deploymentId);
    }

    @Override
    public void deleteAutoGeneratedDeployments(String taskId) {
        this.deploymentPersistence.deleteAllAutoGenerated(taskId);
    }

    public SqlDeploymentRepository(DeploymentPersistence deploymentPersistence, DeploymentHistoryPersistence deploymentHistoryPersistence, @Qualifier(value="reportingSqlDialect") SqlBuilder.Dialect dialect) {
        this.deploymentPersistence = deploymentPersistence;
        this.deploymentHistoryPersistence = deploymentHistoryPersistence;
        this.dialect = dialect;
    }
}

