/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.udm.reporting.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.udm.reporting.Deployment;
import com.xebialabs.xlrelease.udm.reporting.repository.DeploymentRepository;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.reflect.ScalaSignature;

@Path(value="fixtures/deployment")
@Controller
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001E\u0011!\u0003R3qY>LX.\u001a8ug\u001aK\u0007\u0010^;sK*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003%\u0011X\r]8si&twM\u0003\u0002\n\u0015\u0005\u0019Q\u000fZ7\u000b\u0005-a\u0011!\u0003=me\u0016dW-Y:f\u0015\tia\"A\u0005yK\nL\u0017\r\\1cg*\tq\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aD\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0015I\u0016\u0004Hn\\=nK:$(+\u001a9pg&$xN]=\u0016\u0003m\u0001\"\u0001H\u0010\u000e\u0003uQ!A\b\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002!;\t!B)\u001a9m_flWM\u001c;SKB|7/\u001b;pefD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0016I\u0016\u0004Hn\\=nK:$(+\u001a9pg&$xN]=!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00039fe6L7o]5p]N,\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S)\t\u0001b]3dkJLG/_\u0005\u0003W!\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0011!i\u0003A!A!\u0002\u00131\u0013\u0001\u00049fe6L7o]5p]N\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011AGC\u0001\bg\u0016\u0014h/[2f\u0013\t14GA\u0006DS&#7+\u001a:wS\u000e,\u0007\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\t\u000bi\u0002A\u0011A\u001e\u0002\rqJg.\u001b;?)\u0011adh\u0010!\u0011\u0005u\u0002Q\"\u0001\u0002\t\u000beI\u0004\u0019A\u000e\t\u000b\u0011J\u0004\u0019\u0001\u0014\t\u000b=J\u0004\u0019A\u0019)\u0005e\u0012\u0005CA\"O\u001b\u0005!%BA#G\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u000f\"\u000bqAZ1di>\u0014\u0018P\u0003\u0002J\u0015\u0006)!-Z1og*\u00111\nT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ*A\u0002pe\u001eL!a\u0014#\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B)\u0001\t\u0003\u0011\u0016\u0001E2sK\u0006$X\rR3qY>LX.\u001a8u)\t\u0019f\f\u0005\u0002U7:\u0011Q+\u0017\t\u0003-Ri\u0011a\u0016\u0006\u00031B\ta\u0001\u0010:p_Rt\u0014B\u0001.\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i#\u0002\"B0Q\u0001\u0004\u0001\u0017A\u00033fa2|\u00170\\3oiB\u0011\u0011MY\u0007\u0002\r%\u00111M\u0002\u0002\u000b\t\u0016\u0004Hn\\=nK:$\bF\u0001)f!\t1W.D\u0001h\u0015\tA\u0017.\u0001\u0002sg*\u0011!n[\u0001\u0003oNT\u0011\u0001\\\u0001\u0006U\u00064\u0018\r_\u0005\u0003]\u001e\u0014A\u0001U(T)\")\u0001\u000f\u0001C\u0001c\u0006\u0001B-\u001a7fi\u0016$U\r\u001d7ps6,g\u000e\u001e\u000b\u0003eV\u0004\"aE:\n\u0005Q$\"\u0001B+oSRDQA^8A\u0002M\u000bA\u0002Z3qY>LX.\u001a8u\u0013\u0012DC!\u001e=|yB\u0011a-_\u0005\u0003u\u001e\u0014\u0011\u0002U1uQB\u000b'/Y7\u0002\u000bY\fG.^3\"\u0003YDSa\u001c@|\u0003\u0007\u0001\"AZ@\n\u0007\u0005\u0005qM\u0001\u0003QCRD\u0017EAA\u0003\u0003EYH-\u001a9m_flWM\u001c;JIjr#& \u0015\u0004_\u0006%\u0001c\u00014\u0002\f%\u0019\u0011QB4\u0003\r\u0011+E*\u0012+FQ\u0019\u0001\u0011\u0011C>\u0002\u0018A\u0019a-a\u0005\n\u0007\u0005UqM\u0001\u0005D_:\u001cX/\\3tY\t\tI\"\t\u0002\u0002\u001c\u0005\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\u001c\u0015\u0007\u0001\u0005}10!\n\u0011\u0007\u0019\f\t#C\u0002\u0002$\u001d\u0014\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u00033A3\u0001AA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\u0015\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005M\u0012Q\u0006\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b&\u0002\u0001\u007fw\u0006]\u0012EAA\u001d\u0003M1\u0017\u000e\u001f;ve\u0016\u001cx\u0006Z3qY>LX.\u001a8u\u0001")
public class DeploymentsFixture {
    private final DeploymentRepository deploymentRepository;
    private final PermissionChecker permissions;
    private final CiIdService ciIdService;

    public DeploymentRepository deploymentRepository() {
        return this.deploymentRepository;
    }

    public PermissionChecker permissions() {
        return this.permissions;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @POST
    public String createDeployment(Deployment deployment) {
        this.permissions().check(PlatformPermissions.ADMIN);
        deployment.setDeploymentId(Ids.getName((String)this.ciIdService().getUniqueId("Deployment", "")));
        this.deploymentRepository().create(deployment);
        return deployment.getDeploymentId();
    }

    @DELETE
    @Path(value="{deploymentId:.*}")
    public void deleteDeployment(@PathParam(value="deploymentId") String deploymentId) {
        this.permissions().check(PlatformPermissions.ADMIN);
        this.deploymentRepository().delete(deploymentId);
    }

    @Autowired
    public DeploymentsFixture(DeploymentRepository deploymentRepository, PermissionChecker permissions, CiIdService ciIdService) {
        this.deploymentRepository = deploymentRepository;
        this.permissions = permissions;
        this.ciIdService = ciIdService;
    }
}

