import { createSlice, PayloadAction } from '@reduxjs/toolkit';

import noop from 'lodash/noop';
import { RootState } from '@xlr-ui/app/js/store.types';
import { WithTitleAndId } from '@xlr-ui/app/types';

export interface DeploymentTaskFacetState {
    applications: Array<WithTitleAndId>;
    environments: Array<WithTitleAndId>;
}

export const initialState: DeploymentTaskFacetState = {
    applications: [],
    environments: [],
};

export const deploymentTaskFacet = createSlice({
    name: 'deploymentTaskFacet',
    initialState,
    reducers: {
        loadApplications: (_state: DeploymentTaskFacetState, _action: PayloadAction<string>) => noop(),
        loadEnvironments: (_state: DeploymentTaskFacetState, _action: PayloadAction<string>) => noop(),
        setApplications: (state: DeploymentTaskFacetState, action: PayloadAction<Array<WithTitleAndId>>) => {
            state.applications = action.payload;
        },
        setEnvironments: (state: DeploymentTaskFacetState, action: PayloadAction<Array<WithTitleAndId>>) => {
            state.environments = action.payload;
        },
    },
});

export const getDeploymentTaskFacetState = (state: RootState): DeploymentTaskFacetState => state.deploymentTaskFacet;
