package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

public class ChangeNumbersFilter extends SimpleFilter {

    @Property(description = "Change numbers")
    private Set<String> changeNumbers;

    public ChangeNumbersFilter() {
    }

    public ChangeNumbersFilter(Set<String> changeNumbers) {
        this.changeNumbers = changeNumbers;
    }

    public ChangeNumbersFilter(String ... changeNumbers) {
        this.changeNumbers = new HashSet<>();
        this.changeNumbers.addAll(Arrays.asList(changeNumbers));
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final ChangeNumbersFilter that = (ChangeNumbersFilter) o;
        return Objects.equals(changeNumbers, that.changeNumbers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), changeNumbers);
    }

    @Override
    public String toString() {
        return "ChangeNumbersFilter[" + "changeNumbers=" + changeNumbers + "]";
    }

    public Set<String> getChangeNumbers() {
        return changeNumbers;
    }

    public void setChangeNumbers(final Set<String> changeNumbers) {
        this.changeNumbers = changeNumbers;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }
}
