package com.xebialabs.xlrelease.udm.reporting.repository.sql.queries

import com.xebialabs.xlrelease.domain.status.ReleaseStatus
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import com.xebialabs.xlrelease.reports.filters.CompositeFilter.Operator
import com.xebialabs.xlrelease.udm.reporting.filters.CompositeFilter
import com.xebialabs.xlrelease.udm.reporting.filters.impl.ReleaseStatusFilter

import java.util.{Map => JMap}

trait LiveQuery {

  def executeSummary(tile: Tile, additionalParameters: JMap[String, Any]): AnyRef

  def executeDetails(tile: Tile, additionalParameters: JMap[String, Any]): AnyRef

  def statusFilter(statuses: Seq[ReleaseStatus]): CompositeFilter = {
    new CompositeFilter(Operator.OR, statuses.map(new ReleaseStatusFilter(_)):_*)
  }
}
