package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

public class EnvironmentNamesFilter extends SimpleFilter {
    @Property(description = "Environments")
    private Set<String> environmentNames;

    public EnvironmentNamesFilter() {

    }

    public EnvironmentNamesFilter(Set<String> environmentNames) {
        this.environmentNames = environmentNames;
    }

    public EnvironmentNamesFilter(String ... environmentNames) {
        this.environmentNames = new HashSet<>();
        this.environmentNames.addAll(Arrays.asList(environmentNames));
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final EnvironmentNamesFilter that = (EnvironmentNamesFilter) o;
        return Objects.equals(environmentNames, that.environmentNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), environmentNames);
    }

    @Override
    public String toString() {
        return "EnvironmentNamesFilter[" + "environmentNames=" + environmentNames + "]";
    }

    public Set<String> getEnvironmentNames() {
        return environmentNames;
    }

    public void setEnvironmentNames(final Set<String> environmentNames) {
        this.environmentNames = environmentNames;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }
}