package com.xebialabs.xlrelease.udm.reporting.filters;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.Objects;

@Metadata(label = "EnvironmentFilter", versioned = false)
public class EnvironmentFilter extends SimpleFilter {
    @Property(description = "The ID of the environment to filter.")
    private String environmentId = "";

    public EnvironmentFilter() {
    }

    public EnvironmentFilter(String environmentId) {
        this.environmentId = environmentId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final EnvironmentFilter that = (EnvironmentFilter) o;
        return Objects.equals(environmentId, that.environmentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), environmentId);
    }

    @Override
    public String toString() {
        return "EnvironmentFilter[environmentId = " + environmentId + "]";
    }

    public String getEnvironmentId() {
        return environmentId;
    }

    public void setEnvironmentId(final String environmentId) {
        this.environmentId = environmentId;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

}
