package com.xebialabs.xlrelease.udm.reporting;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.facet.ConfigurationFacet;

import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;

@Metadata(label = "Deployment")
public class DeploymentTaskFacet extends ConfigurationFacet {
    @Property(category = CATEGORY_INPUT, label = "Application ID", description = "The key of the application whose version is being deployed by this task.")
    private String applicationId;
    @Property(category = CATEGORY_INPUT, label = "Environment ID", description = "The name of the environment where this task deploys on.")
    private String environmentId;
    @Property(category = CATEGORY_INPUT, label = "Application version", description = "The version of application.")
    private String version;

    @Override
    public String toString() {
        return "DeploymentTaskFacet[" +
                "id='" + id + '\'' +
                ", applicationId='" + applicationId + '\'' +
                ", environmentId='" + environmentId + '\'' +
                ", version='" + version + '\'' +
                ", targetId='" + getTargetId() + '\'' +
                ']';
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(final String applicationId) {
        this.applicationId = applicationId;
    }

    public String getEnvironmentId() {
        return environmentId;
    }

    public void setEnvironmentId(final String environmentId) {
        this.environmentId = environmentId;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(final String version) {
        this.version = version;
    }

}
