package com.xebialabs.xlrelease.udm.reporting.filters

import com.xebialabs.xlrelease.db.ArchivedReleases.{REPORT_RELEASES_ORIGIN_TEMPLATE_ID, REPORT_RELEASES_TABLE_ALIAS}
import com.xebialabs.xlrelease.db.sql.archiving.BaseSelectArchivedBuilder
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.impl.TagsFilter.Operator
import com.xebialabs.xlrelease.udm.reporting.filters.impl._

import java.lang.String.format
import java.util
import java.util.Collections.singletonList
import scala.jdk.CollectionConverters._

abstract class ArchiveSqlFilterVisitor[T <: BaseSelectArchivedBuilder[T]](override val builder: T)
  extends UdmReportFilterSqlBuilderVisitor[T](builder) {

  override def visit(filter: DateFilter): Unit = {
    if (filter.getTimeFrame != null) {
      builder.withDates(
        filter.getTimeFrame,
        filter.getFrom,
        filter.getTo
      )
    }
  }

  override def visit(filter: FolderFilter): Unit = {
    builder.withFolder(filter.getFolderId)
  }

  override def visit(filter: TagsFilter): Unit = {
    if (filter.getOperator eq Operator.CONTAINS_ALL) {
      builder.withAllTags(filter.getTags)
    } else {
      builder.withAnyOfTags(filter.getTags)
    }
  }

  override def visit(filter: TemplateFilter): Unit = {
    if (filter.getTemplateId != null) {
      val params: util.List[AnyRef] = singletonList(Ids.getName(filter.getTemplateId))
      builder.withCondition(format("%s = ?", REPORT_RELEASES_TABLE_ALIAS + "." + REPORT_RELEASES_ORIGIN_TEMPLATE_ID), params)
    }
  }

  override def visit(filter: ChangeNumbersFilter): Unit = {
    Option(filter.getChangeNumbers)
      .map(_.asScala.filter(_.nonEmpty).toSet)
      .filter(_.nonEmpty)
      .foreach(builder.withChangeNumbers)
  }

  override def visit(filter: ApplicationNamesFilter): Unit = {
    Option(filter.getApplicationNames)
      .map(_.asScala.filter(_.nonEmpty).toSet)
      .filter(_.nonEmpty)
      .foreach(builder.withApplicationNames)
  }

  override def visit(filter: EnvironmentNamesFilter): Unit = {
    Option(filter.getEnvironmentNames)
      .map(_.asScala.filter(_.nonEmpty).toSet)
      .filter(_.nonEmpty)
      .foreach(builder.withEnvironmentNames)
  }

  override def visit(filter: ReleaseStatusFilter): Unit = {
    throw new IllegalStateException("not possible")
  }

  override def visit(filter: RiskFilter): Unit = {
    throw new IllegalStateException("not possible")
  }

  override def visit(filter: ReleaseKindFilter): Unit = {
    builder.withKind(filter.getKind)
  }
}
