import React from 'react';
import { TaskAttributeProps } from '@xlr-ui/app/features/tasks/components/rails/attributes/types';
import { mountWithStoreAndTheme } from '@xlr-ui/tests/unit/testing-utils';
import { DeploymentTaskFacetCommon } from './deployment-task-facet-common.component';
import { deploymentTaskFacet } from '../../ducks/deployment-task-facet.reducer';
import { DeploymentTaskFacetEnvironment } from './deployment-task-facet-environment.component';

const { loadEnvironments } = deploymentTaskFacet.actions;

describe('DeploymentTaskFacetEnvironment', () => {
    const dispatch = jest.fn();

    const props: TaskAttributeProps = {
        onChange: jest.fn(),
        disabled: false,
        facet: { targetId: 'Folder42/Release42' } as never,
        onNewVariable: jest.fn(),
        property: {} as never,
    };

    const environments = ['1', '2'];

    it('should create DeploymentTaskFacetCommon', () => {
        const wrapper = mountWithStoreAndTheme(<DeploymentTaskFacetEnvironment {...props} />, dispatch, { deploymentTaskFacet: { environments } });
        const common = wrapper.find(DeploymentTaskFacetCommon).props();
        expect(common.disabled).toStrictEqual(props.disabled);
        expect(common.onChange).toStrictEqual(props.onChange);
        expect(common.facet).toStrictEqual(props.facet);
        expect(common.onNewVariable).toStrictEqual(props.onNewVariable);
        expect(common.property).toStrictEqual(props.property);
        expect(common.options).toStrictEqual(environments);
        expect(common.onInit).toStrictEqual(loadEnvironments);
    });
});
