import React from 'react';
import { TaskAttributeProps } from '@xlr-ui/app/features/tasks/components/rails/attributes/types';
import { useAppSelector } from '@xlr-ui/app/js/hooks';

import { deploymentTaskFacet, DeploymentTaskFacetState, getDeploymentTaskFacetState } from '../../ducks/deployment-task-facet.reducer';
import { DeploymentTaskFacetCommon } from './deployment-task-facet-common.component';

const { loadApplications } = deploymentTaskFacet.actions;

export const DeploymentTaskFacetApplication = ({ disabled, facet, property, onNewVariable, onChange }: TaskAttributeProps) => {
    const { applications }: DeploymentTaskFacetState = useAppSelector(getDeploymentTaskFacetState);

    return (
        <DeploymentTaskFacetCommon
            disabled={disabled}
            facet={facet}
            onChange={onChange}
            onInit={loadApplications}
            onNewVariable={onNewVariable}
            options={applications}
            property={property}
        />
    );
};
