import { all, call, put, takeLatest } from 'redux-saga/effects';
import { IHttpResponse } from 'angular';
import { PayloadAction } from '@reduxjs/toolkit';
import { deploymentTaskFacet } from './deployment-task-facet.reducer';
import { httpPOST } from '@xlr-ui/app/features/common/services/http';
import { WithTitleAndId } from '@xlr-ui/app/types';

const { loadApplications, loadEnvironments, setApplications, setEnvironments } = deploymentTaskFacet.actions;

export function* loadApplicationsSaga({ payload: folderId }: PayloadAction<string>) {
    const { data }: IHttpResponse<Array<WithTitleAndId>> = yield call(httpPOST, 'api/v1/applications/search', { folderId, scope: 'GLOBAL_AND_FOLDER' });
    yield put(setApplications(data));
}

export function* loadEnvironmentsSaga({ payload: folderId }: PayloadAction<string>) {
    const { data }: IHttpResponse<Array<WithTitleAndId>> = yield call(httpPOST, 'api/v1/environments/search', { folderId, scope: 'GLOBAL_AND_FOLDER' });
    yield put(setEnvironments(data));
}

export function* deploymentTaskFacetSaga() {
    yield all([takeLatest(loadApplications, loadApplicationsSaga), takeLatest(loadEnvironments, loadEnvironmentsSaga)]);
}
