/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;
import java.util.Date;
import java.util.Objects;

@Metadata(label="DateFilter", versioned=false)
public class DateFilter
extends SimpleFilter {
    @Property(required=false, description="Predefined time-frame to apply to the reports query.")
    private TimeFrame timeFrame = TimeFrame.LAST_SEVEN_DAYS;
    @Property(required=false, description="Overrides the predefined time-frame with a custom from date.")
    private Date from;
    @Property(required=false, description="Overrides the predefined time-frame with a custom to date.")
    private Date to;

    public DateFilter() {
    }

    public DateFilter(TimeFrame timeFrame, Date from, Date to) {
        this.timeFrame = timeFrame;
        this.from = from;
        this.to = to;
    }

    public DateFilter(TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateFilter that = (DateFilter)o;
        return this.timeFrame == that.timeFrame && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeFrame, this.from, this.to);
    }

    public String toString() {
        return "DateFilter[from = " + String.valueOf(this.from) + ", to = " + String.valueOf(this.to) + ", timeFrame = " + String.valueOf(this.timeFrame) + "]";
    }

    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }

    public void setTimeFrame(TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

