import { all, call } from 'redux-saga/effects';

import { deploymentTaskFacet } from './deployment-task-facet.reducer';
import { deploymentTaskFacetSaga } from './deployment-task-facet.saga';
import { enhanceStore } from '@xlr-ui/app/js/app-config';

function* combinedSaga() {
    while (true) {
        try {
            yield all([call(deploymentTaskFacetSaga)]);
        } catch (e) {
            // eslint-disable-next-line no-console,angular/log
            console.error('deploymentTask root saga:', e);
        }
    }
}

enhanceStore(
    {
        deploymentTaskFacet: deploymentTaskFacet.reducer,
    },
    combinedSaga,
);
