import { SagaIterator } from 'redux-saga';
import { all, call, put, takeLatest } from 'redux-saga/effects';
import { PayloadAction } from '@reduxjs/toolkit';
import { deploymentTaskFacet } from './deployment-task-facet.reducer';
import { deploymentTaskFacetSaga, loadApplicationsSaga, loadEnvironmentsSaga } from './deployment-task-facet.saga';
import { httpPOST } from '@xlr-ui/app/features/common/services/http';

const { loadApplications, loadEnvironments, setApplications, setEnvironments } = deploymentTaskFacet.actions;

describe('deploymentTaskFacetSaga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = deploymentTaskFacetSaga();
        expect(gen.next().value).toStrictEqual(all([takeLatest(loadApplications, loadApplicationsSaga), takeLatest(loadEnvironments, loadEnvironmentsSaga)]));
        expect(gen.next().done).toBe(true);
    });
    describe('loadApplicationsSaga', () => {
        it('should call proper saga', () => {
            const applications = ['1', '2'];
            const folderId = 'Folder42';
            const payload: PayloadAction<string> = {
                type: 'deployment-task-facet/loadApplications',
                payload: folderId,
            };
            const gen: SagaIterator = loadApplicationsSaga(payload);
            expect(gen.next().value).toStrictEqual(call(httpPOST, 'api/v1/applications/search', { folderId, scope: 'GLOBAL_AND_FOLDER' }));
            expect(gen.next({ data: applications }).value).toStrictEqual(put(setApplications(applications as never)));
            expect(gen.next().done).toBe(true);
        });
    });
    describe('loadEnvironmentsSaga', () => {
        it('should call proper saga', () => {
            const environments = ['1', '2'];
            const folderId = 'Folder42';
            const payload: PayloadAction<string> = {
                type: 'deployment-task-facet/loadEnvironments',
                payload: folderId,
            };
            const gen: SagaIterator = loadEnvironmentsSaga(payload);
            expect(gen.next().value).toStrictEqual(call(httpPOST, 'api/v1/environments/search', { folderId, scope: 'GLOBAL_AND_FOLDER' }));
            expect(gen.next({ data: environments }).value).toStrictEqual(put(setEnvironments(environments as never)));
            expect(gen.next().done).toBe(true);
        });
    });
});
