package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

@Metadata(label = "TemplateFilter", versioned = false)
public class TemplateFilter extends SimpleFilter {
    @Property(description = "The ID of the template to filter.")
    private String templateId = "";

    public TemplateFilter() {
    }

    public TemplateFilter(String templateId) {
        this.templateId = templateId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final TemplateFilter that = (TemplateFilter) o;
        return Objects.equals(templateId, that.templateId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), templateId);
    }

    @Override
    public String toString() {
        return "TemplateFilter[" + "templateId=" + templateId + "]";
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(final String templateId) {
        this.templateId = templateId;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }
}
