package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

public class ApplicationNamesFilter extends SimpleFilter {
    @Property(description = "Applications")
    private Set<String> applicationNames;

    public ApplicationNamesFilter() {
    }

    public ApplicationNamesFilter(Set<String> applicationNames) {
        this.applicationNames = applicationNames;
    }

    public ApplicationNamesFilter(String... applicationNames) {
        this.applicationNames = new HashSet<>();
        this.applicationNames.addAll(Arrays.asList(applicationNames));
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final ApplicationNamesFilter that = (ApplicationNamesFilter) o;
        return Objects.equals(applicationNames, that.applicationNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), applicationNames);
    }

    @Override
    public String toString() {
        return "ApplicationNamesFilter[" + "applicationNames=" + applicationNames + "]";
    }

    public Set<String> getApplicationNames() {
        return applicationNames;
    }

    public void setApplicationNames(final Set<String> applicationNames) {
        this.applicationNames = applicationNames;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }
}