import { deploymentTaskFacet, initialState } from './deployment-task-facet.reducer';

describe('deploymentTaskFacet reducer', () => {
    it('should have initial state', () => {
        expect(deploymentTaskFacet.name).toBe('deploymentTaskFacet');
        // if a new reducer is added, this test should fail and dev must fix and add new one
        expect(Object.keys(deploymentTaskFacet.actions)).toStrictEqual(['loadApplications', 'loadEnvironments', 'setApplications', 'setEnvironments']);
        expect(deploymentTaskFacet.reducer(undefined, { type: 'default' })).toStrictEqual(initialState);
    });

    describe('reducers', () => {
        describe('loadApplications', () => {
            it('should do nothing with state', () => {
                const folderId = 'Folder42';
                const state = deploymentTaskFacet.reducer(initialState, deploymentTaskFacet.actions.loadApplications(folderId));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('loadEnvironments', () => {
            it('should do nothing with state', () => {
                const folderId = 'Folder42';
                const state = deploymentTaskFacet.reducer(initialState, deploymentTaskFacet.actions.loadEnvironments(folderId));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setApplications', () => {
            it('should update state', () => {
                const applications = [{ id: 'FolderId', title: 'title' }];
                const state = deploymentTaskFacet.reducer(initialState, deploymentTaskFacet.actions.setApplications(applications));
                expect(state).toStrictEqual({
                    ...initialState,
                    applications,
                });
            });
        });
        describe('setEnvironments', () => {
            it('should update state', () => {
                const environments = [{ id: 'Environment1', title: 'title' }];
                const state = deploymentTaskFacet.reducer(initialState, deploymentTaskFacet.actions.setEnvironments(environments));
                expect(state).toStrictEqual({
                    ...initialState,
                    environments,
                });
            });
        });
    });
});
