package com.xebialabs.xlrelease.udm.reporting.repository

import com.xebialabs.xlrelease.domain.configuration.HttpConnection
import com.xebialabs.xlrelease.domain.{CustomScriptTask, Task}
import com.xebialabs.xlrelease.udm.reporting.{Deployment, DeploymentAction, DeploymentHistory}

import java.util.Date
import scala.util.Try

object DeploymentHistoryFactory {
  val DEPLOYMENT_TASK_ID_PROPERTY = "xlDeployTaskId"
  val DEPLOYMENT_TASK_SERVER = "server"

  def createDeploymentHistory(current: Deployment, task: Task = null, previous: Option[Deployment] = None): DeploymentHistory = {
    val history = new DeploymentHistory
    history.setDeploymentId(current.getDeploymentId)
    history.setNewStatus(current.getStatus)
    history.setChangeDate(new Date())
    history.setTaskOwner(current.getTaskOwner)
    history.setTaskTeam(current.getTaskTeam)
    Option(task).map(createDeployTaskUrl).map(_.orNull).foreach(history.setDeployUrl)

    previous.fold {
      history.setOldStatus(current.getStatus)
      history.setAction(DeploymentAction.fromStatus(null, current.getStatus))
      history
    } { p =>
      history.setOldStatus(p.getStatus)
      history.setAction(DeploymentAction.fromStatus(p.getStatus, current.getStatus))
      history
    }
  }

  private def createDeployTaskUrl(task: Task): Option[String] = {
    task match {
      case t: CustomScriptTask =>
        Try(t.getPythonScript.getProperty[HttpConnection](DEPLOYMENT_TASK_SERVER) -> t.getPythonScript.getProperty[String](DEPLOYMENT_TASK_ID_PROPERTY))
          .collect {
            case (server, xlDeployTaskId) if xlDeployTaskId.nonEmpty => s"${server.getUrl}/#/task/$xlDeployTaskId"
          }.toOption
      case _ => None
    }
  }
}
