package com.xebialabs.xlrelease.udm.reporting.filters;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.Objects;

@Metadata(label = "ApplicationFilter", versioned = false)
public class ApplicationFilter extends SimpleFilter {
    @Property(description = "The ID of the application to filter.")
    private String applicationId = "";

    public ApplicationFilter() {
    }

    public ApplicationFilter(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final ApplicationFilter that = (ApplicationFilter) o;
        return Objects.equals(applicationId, that.applicationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), applicationId);
    }

    @Override
    public String toString() {
        return "ApplicationFilter[applicationId = " + applicationId + "]";
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(final String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

}
