package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

@Metadata(label = "TagsFilter", versioned = false)
public class TagsFilter extends SimpleFilter {
    @Property(description = "Operator to apply when filtering tags.", defaultValue = "CONTAINS_ANY")
    private Operator operator = Operator.CONTAINS_ANY;

    @Property(description = "The tags to filter.")
    private List<String> tags = new ArrayList<>();

    public TagsFilter() {
    }

    public TagsFilter(List<String> tags) {
        this.tags = tags;
    }

    public TagsFilter(String... tags) {
        this.tags = Arrays.asList(tags);
    }

    public TagsFilter(Operator operator, List<String> tags) {
        this.operator = operator;
        this.tags = tags;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final TagsFilter that = (TagsFilter) o;
        return operator == that.operator &&
                Objects.equals(tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), operator, tags);
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(final List<String> tags) {
        this.tags = tags;
    }

    public Operator getOperator() {
        return operator;
    }

    public void setOperator(final Operator operator) {
        this.operator = operator;
    }

    public enum Operator {
        CONTAINS_ANY("CONTAINS_ANY"),
        CONTAINS_ALL("CONTAINS_ALL");

        private String value;

        Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        return "TagsFilter[" + "operator=" + operator + ", tags=" + tags + "]";
    }
}
