/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.udm.reporting.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.udm.reporting.Deployment;
import com.xebialabs.xlrelease.udm.reporting.repository.DeploymentRepository;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.reflect.ScalaSignature;

@Path(value="fixtures/deployment")
@Controller
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\u0006\f\u0001iA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005G!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000bq\u0002A\u0011A\u001f\t\u000bI\u0003A\u0011A*\t\u000bA\u0004A\u0011A9\u0003%\u0011+\u0007\u000f\\8z[\u0016tGo\u001d$jqR,(/\u001a\u0006\u0003\u00195\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001d=\t1!\u00199j\u0015\t\u0001\u0012#A\u0005sKB|'\u000f^5oO*\u0011!cE\u0001\u0004k\u0012l'B\u0001\u000b\u0016\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0017/\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002)\u0011,\u0007\u000f\\8z[\u0016tGOU3q_NLGo\u001c:z+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0010\u0003)\u0011X\r]8tSR|'/_\u0005\u0003Q\u0015\u0012A\u0003R3qY>LX.\u001a8u%\u0016\u0004xn]5u_JL\u0018!\u00063fa2|\u00170\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\fa\u0016\u0014X.[:tS>t7/F\u0001-!\ti\u0003'D\u0001/\u0015\ty3#\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\tdFA\tQKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\fA\u0002]3s[&\u001c8/[8og\u0002\n1bY5JIN+'O^5dKV\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029'\u000591/\u001a:wS\u000e,\u0017B\u0001\u001e8\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\u0011q\u0004)\u0011\"\u0011\u0005}\u0002Q\"A\u0006\t\u000b\u0005:\u0001\u0019A\u0012\t\u000b):\u0001\u0019\u0001\u0017\t\u000bM:\u0001\u0019A\u001b)\u0005\u001d!\u0005CA#Q\u001b\u00051%BA$I\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0013*\u000bqAZ1di>\u0014\u0018P\u0003\u0002L\u0019\u0006)!-Z1og*\u0011QJT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq*A\u0002pe\u001eL!!\u0015$\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001E2sK\u0006$X\rR3qY>LX.\u001a8u)\t!v\f\u0005\u0002V9:\u0011aK\u0017\t\u0003/vi\u0011\u0001\u0017\u0006\u00033f\ta\u0001\u0010:p_Rt\u0014BA.\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mk\u0002\"\u00021\t\u0001\u0004\t\u0017A\u00033fa2|\u00170\\3oiB\u0011!mY\u0007\u0002\u001f%\u0011Am\u0004\u0002\u000b\t\u0016\u0004Hn\\=nK:$\bF\u0001\u0005g!\t9g.D\u0001i\u0015\tI'.\u0001\u0002sg*\u00111\u000e\\\u0001\u0003oNT\u0011!\\\u0001\bU\u0006\\\u0017M\u001d;b\u0013\ty\u0007N\u0001\u0003Q\u001fN#\u0016\u0001\u00053fY\u0016$X\rR3qY>LX.\u001a8u)\t\u0011X\u000f\u0005\u0002\u001dg&\u0011A/\b\u0002\u0005+:LG\u000fC\u0003w\u0013\u0001\u0007A+\u0001\u0007eKBdw._7f]RLE\r\u000b\u0003vqnd\bCA4z\u0013\tQ\bNA\u0005QCRD\u0007+\u0019:b[\u0006)a/\u00197vK\u0006\na\u000f\u000b\u0002\n}B\u0011qm`\u0005\u0004\u0003\u0003A'A\u0002#F\u0019\u0016#V\t\u000b\u0004\n\u0003\u000bY\u00181\u0002\t\u0004O\u0006\u001d\u0011bAA\u0005Q\n!\u0001+\u0019;iC\t\ti!A\t|I\u0016\u0004Hn\\=nK:$\u0018\n\u001a\u001e/UuDc\u0001AA\u0003w\u0006E\u0011EAA\n\u0003M1\u0017\u000e\u001f;ve\u0016\u001cx\u0006Z3qY>LX.\u001a8uQ\r\u0001\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004'\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\"\u0005m!AC\"p]R\u0014x\u000e\u001c7fe\"2\u0001!!\n|\u0003W\u00012aZA\u0014\u0013\r\tI\u0003\u001b\u0002\t!J|G-^2fg2\u0012\u0011QF\u0011\u0003\u0003_\t\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\r\u0001\t\u0019d_A\u001d!\r9\u0017QG\u0005\u0004\u0003oA'\u0001C\"p]N,X.Z:-\u0005\u00055\u0002")
public class DeploymentsFixture {
    private final DeploymentRepository deploymentRepository;
    private final PermissionChecker permissions;
    private final CiIdService ciIdService;

    public DeploymentRepository deploymentRepository() {
        return this.deploymentRepository;
    }

    public PermissionChecker permissions() {
        return this.permissions;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @POST
    public String createDeployment(Deployment deployment) {
        this.permissions().check(PlatformPermissions.ADMIN);
        deployment.setDeploymentId(Ids.getName((String)this.ciIdService().getUniqueId("Deployment", "")));
        this.deploymentRepository().create(deployment, this.deploymentRepository().create$default$2());
        return deployment.getDeploymentId();
    }

    @DELETE
    @Path(value="{deploymentId:.*}")
    public void deleteDeployment(@PathParam(value="deploymentId") String deploymentId) {
        this.permissions().check(PlatformPermissions.ADMIN);
        this.deploymentRepository().delete(deploymentId);
    }

    @Autowired
    public DeploymentsFixture(DeploymentRepository deploymentRepository, PermissionChecker permissions, CiIdService ciIdService) {
        this.deploymentRepository = deploymentRepository;
        this.permissions = permissions;
        this.ciIdService = ciIdService;
    }
}

