package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

import java.util.Objects;

@Metadata(label = "ReleaseFilter", versioned = false)
public class ReleaseFilter extends SimpleFilter {
    @Property(description = "The title the release to filter.")
    private String releaseTitle = "";

    public ReleaseFilter() {
    }

    public ReleaseFilter(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public String getReleaseTitle() {
        return releaseTitle;
    }

    public void setReleaseTitle(final String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final ReleaseFilter that = (ReleaseFilter) o;
        return releaseTitle.equals(that.releaseTitle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), releaseTitle);
    }

    @Override
    public String toString() {
        return "ReleaseFilter[releaseTitle = " + releaseTitle + "]";
    }
}
