package com.xebialabs.xlrelease.udm.reporting;

import java.io.Serializable;
import java.util.Date;

import com.xebialabs.xlrelease.domain.udm.reporting.DeploymentStatus;

// TODO: rename deployment history to deployment activity
public class DeploymentHistory implements Serializable {
    private String deploymentId;
    private DeploymentStatus oldStatus;
    private DeploymentStatus newStatus;
    private DeploymentAction action;
    private Date changeDate;
    private String taskOwner;
    private String taskTeam;

    //Advantages of storing URL
    //  - Ready to use, no need to find server URL
    //  - You can still parse task id out of it
    //  - Consistent with 'build URL' on Jenkins task
    //
    //Disadvantages
    //  * Feels weird to store derived/compound data
    private String deployUrl;

    public String getDeploymentId() {
        return deploymentId;
    }

    public void setDeploymentId(final String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public DeploymentStatus getOldStatus() {
        return oldStatus;
    }

    public void setOldStatus(final DeploymentStatus oldStatus) {
        this.oldStatus = oldStatus;
    }

    public DeploymentStatus getNewStatus() {
        return newStatus;
    }

    public void setNewStatus(final DeploymentStatus newStatus) {
        this.newStatus = newStatus;
    }

    public DeploymentAction getAction() {
        return action;
    }

    public void setAction(final DeploymentAction action) {
        this.action = action;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(final Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getTaskOwner() {
        return taskOwner;
    }

    public void setTaskOwner(final String taskOwner) {
        this.taskOwner = taskOwner;
    }

    public String getTaskTeam() {
        return taskTeam;
    }

    public void setTaskTeam(final String taskTeam) {
        this.taskTeam = taskTeam;
    }

    public String getDeployUrl() {
        return deployUrl;
    }

    public void setDeployUrl(final String deployUrl) {
        this.deployUrl = deployUrl;
    }

    @Override
    public String toString() {
        return "DeploymentHistory[" +
                "deploymentId='" + deploymentId + '\'' +
                ", action='" + action + '\'' +
                ", status='" + oldStatus + '\'' + " -> '" + newStatus + '\'' +
                ", deployUrl='" + deployUrl + '\'' +
                ", changeDate='" + changeDate + '\'' +
                ", taskOwner='" + taskOwner + '\'' +
                ']';
    }
}
