package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

@Metadata(label = "ReleaseKindFilter", versioned = false)
public class ReleaseKindFilter extends SimpleFilter {

    @Property(description = "The kind of the release to filter.")
    private ReleaseKind kind;

    public ReleaseKindFilter() {
    }

    public ReleaseKindFilter(ReleaseKind kind) {
        this.kind = kind;
    }

    public ReleaseKind getKind() {
        return kind;
    }

    public void setKind(ReleaseKind kind) {
        this.kind = kind;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final ReleaseKindFilter that = (ReleaseKindFilter) o;
        return this.kind == that.kind;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), kind);
    }

    @Override
    public String toString() {
        return "ReleaseKindFilter[kind = " + kind + "]";
    }
}
