import React from 'react';
import { TaskAttributeProps } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/attributes/types';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { DeploymentTaskFacetApplication } from './deployment-task-facet-application.component';
import { DeploymentTaskFacetCommon } from './deployment-task-facet-common.component';
import { deploymentTaskFacet } from '../../ducks/deployment-task-facet.reducer';
const { loadApplications } = deploymentTaskFacet.actions;

describe('DeploymentTaskFacetApplication', () => {
    const dispatch = jest.fn();

    const props: TaskAttributeProps = {
        onChange: jest.fn(),
        disabled: false,
        facet: { targetId: 'Folder42/Release42' } as never,
        onNewVariable: jest.fn(),
        property: {} as never,
    };

    const applications = ['1', '2'];

    it('should create DeploymentTaskFacetCommon', () => {
        const wrapper = mountWithStoreAndTheme(<DeploymentTaskFacetApplication {...props} />, dispatch, { deploymentTaskFacet: { applications } });
        const common = wrapper.find(DeploymentTaskFacetCommon).props();
        expect(common.disabled).toStrictEqual(props.disabled);
        expect(common.onChange).toStrictEqual(props.onChange);
        expect(common.facet).toStrictEqual(props.facet);
        expect(common.onNewVariable).toStrictEqual(props.onNewVariable);
        expect(common.property).toStrictEqual(props.property);
        expect(common.options).toStrictEqual(applications);
        expect(common.onInit).toStrictEqual(loadApplications);
    });
});
