package com.xebialabs.xlrelease.udm.reporting.filters

import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder
import com.xebialabs.xlrelease.udm.reporting.filters.impl.TagsFilter.Operator
import com.xebialabs.xlrelease.udm.reporting.filters.impl._

import java.util.Date
import scala.jdk.CollectionConverters._

class NonArchiveSqlFilterVisitor(override val builder: ReleasesSqlBuilder)
  extends UdmReportFilterSqlBuilderVisitor[ReleasesSqlBuilder](builder)
{
  override def visit(filter: DateFilter): Unit = {
    if (filter.getTimeFrame != null) {
      builder.withDates(
        new Date(filter.getTimeFrame.getStartDate(filter.getFrom)),
        new Date(filter.getTimeFrame.getEndDate(filter.getTo)))
    }
  }

  override def visit(filter: FolderFilter): Unit = {
    builder.withFolder(filter.getFolderId)
  }

  override def visit(filter: TagsFilter): Unit = {
    if (filter.getOperator == Operator.CONTAINS_ALL) {
      builder.withAllTags(filter.getTags.asScala.toSet)
    } else {
      builder.withAnyOfTags(filter.getTags.asScala.toSet)
    }
  }

  override def visit(filter: TemplateFilter): Unit = {
    if (filter.getTemplateId != null) {
      builder.withOriginTemplateId(filter.getTemplateId)
    }
  }

  override def visit(filter: ApplicationFilter): Unit = {
    throw new IllegalStateException("not possible")
  }

  override def visit(filter: EnvironmentFilter): Unit = {
    throw new IllegalStateException("not possible")
  }

  override def visit(filter: EnvironmentLabelFilter): Unit = {
    throw new IllegalStateException("not possible")
  }

  override def visit(filter: EnvironmentStageFilter): Unit = {
    throw new IllegalStateException("not possible")
  }


  override def visit(filter: ReleaseFilter): Unit = {
    if (filter.getReleaseTitle != null && filter.getReleaseTitle.nonEmpty) {
      builder.withTitleLike(filter.getReleaseTitle)
    }
  }

  override def visit(filter: ChangeNumbersFilter): Unit = {
    Option(filter.getChangeNumbers)
      .map(_.asScala.filter(_.nonEmpty).toSet)
      .filter(_.nonEmpty)
      .foreach(builder.withChangeNumbers)
  }

  override def visit(filter: ApplicationNamesFilter): Unit = {
    Option(filter.getApplicationNames)
      .map(_.asScala.filter(_.nonEmpty).toSet)
      .filter(_.nonEmpty)
      .foreach(builder.withApplicationNames)
  }

  override def visit(filter: EnvironmentNamesFilter): Unit = {
    Option(filter.getEnvironmentNames)
      .map(_.asScala.filter(_.nonEmpty).toSet)
      .filter(_.nonEmpty)
      .foreach(builder.withEnvironmentNames)
  }

  override def wrap(builder: ReleasesSqlBuilder): UdmReportFilterSqlBuilderVisitor[ReleasesSqlBuilder] = new NonArchiveSqlFilterVisitor(builder)

  override def visit(filter: ReleaseStatusFilter): Unit = {
    if (filter.getReleaseStatus != null) {
      builder.withStatus(filter.getReleaseStatus)
    }
  }

  override def visit(filter: RiskFilter): Unit = {
    builder.withTotalRiskScoresBetween(filter.getFrom, filter.getTo);
  }

  override def visit(filter: ReleaseKindFilter): Unit = {
    builder.withKind(filter.getKind)
  }
}
