import { SagaIterator } from 'redux-saga';
import { all, call, put, takeLatest } from 'redux-saga/effects';
import { deploymentTaskFacet } from './deployment-task-facet.reducer';
import { deploymentTaskFacetSaga, loadApplicationsSaga, loadEnvironmentsSaga } from './deployment-task-facet.saga';
import { httpPOST } from '../../../../../../../../../core/xlr-ui/app/features/common/services/http';

const { loadApplications, loadEnvironments, setApplications, setEnvironments } = deploymentTaskFacet.actions;

describe('deploymentTaskFacetSaga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = deploymentTaskFacetSaga();
        expect(gen.next().value).toStrictEqual(all([takeLatest(loadApplications, loadApplicationsSaga), takeLatest(loadEnvironments, loadEnvironmentsSaga)]));
        expect(gen.next().done).toBe(true);
    });
    describe('loadApplicationsSaga', () => {
        it('should call proper saga', () => {
            const applications = ['1', '2'];
            const gen: SagaIterator = loadApplicationsSaga();
            expect(gen.next().value).toStrictEqual(call(httpPOST, 'api/v1/applications/search', {}));
            expect(gen.next({ data: applications }).value).toStrictEqual(put(setApplications(applications as never)));
            expect(gen.next().done).toBe(true);
        });
    });
    describe('loadEnvironmentsSaga', () => {
        it('should call proper saga', () => {
            const environments = ['1', '2'];
            const gen: SagaIterator = loadEnvironmentsSaga();
            expect(gen.next().value).toStrictEqual(call(httpPOST, 'api/v1/environments/search', {}));
            expect(gen.next({ data: environments }).value).toStrictEqual(put(setEnvironments(environments as never)));
            expect(gen.next().done).toBe(true);
        });
    });
});
