package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord
import com.xebialabs.xlrelease.domain.udm.reporting.DeploymentRecord
import com.xebialabs.xlrelease.environments.repository.{ApplicationRepository, EnvironmentRepository}
import com.xebialabs.xlrelease.repository.{CiCloneHelper, FacetRepositoryDispatcher, Ids}
import com.xebialabs.xlrelease.udm.reporting.DeploymentTaskFacet
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._
import scala.util.Try

@Service
class UdmFacetConfigurationService @Autowired()(
                                                 facetRepositoryDispatcher: FacetRepositoryDispatcher,
                                                 environmentRepository: EnvironmentRepository,
                                                 applicationRepository: ApplicationRepository
                                               ) extends FacetConfigurationService with Logging {
  override def configureFacet(facet: TaskReportingRecord): (Boolean, Seq[TaskReportingRecord]) = {
    if (facet.getType.instanceOf(Type.valueOf(classOf[DeploymentRecord])) && Ids.isTaskId(facet.getTargetId)) {
      val deploymentFacet = facet.asInstanceOf[DeploymentRecord]
      val configurationFacets = facetRepositoryDispatcher.liveRepository.search(
        new FacetFilters(
          null,
          facet.getTargetId,
          Seq(Type.valueOf(classOf[DeploymentTaskFacet])).asJava
        )
      )
        .collect {
          case dtf: DeploymentTaskFacet => dtf
        }
      if (configurationFacets.isEmpty) {
        false -> Seq(facet)
      } else {
        true -> configurationFacets.map(configurationFacet => {
          val copy = CiCloneHelper.cloneCi(deploymentFacet)
          copy.setApplicationName(resolveApplication(configurationFacet.getApplicationId))
          copy.setEnvironmentName(resolveEnvironment(configurationFacet.getEnvironmentId))
          copy.setVersion(configurationFacet.getVersion)
          copy
        })
      }
    } else {
      false -> Seq(facet)
    }
  }

  def resolveApplication(applicationId: String): String =
    Try(applicationRepository.findApplicationById(applicationId)).fold(
      t => {
        logger.warn(t.getMessage)
        Ids.getName(applicationId)
      },
      _.getTitle
    )


  def resolveEnvironment(environmentId: String): String =
    Try(environmentRepository.findEnvironmentById(environmentId)).fold(
      t => {
        logger.warn(t.getMessage)
        Ids.getName(environmentId)
      },
      _.getTitle
    )
}
