package com.xebialabs.xlrelease.udm.reporting.filters

import com.xebialabs.xlrelease.db.sql.SqlBuilder
import com.xebialabs.xlrelease.db.sql.archiving.{SelectArchivedPhasesBuilder, SelectArchivedReleasesBuilder, SelectArchivedTasksBuilder}
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder
import com.xebialabs.xlrelease.udm.reporting.repository.sql.DeploymentsSqlBuilder

object UdmReportFilterSqlBuilderVisitor {
  def forBuilder(builder: SqlBuilder[_]): UdmReportFilterSqlBuilderVisitor[_] = builder match {
    case b: ReleasesSqlBuilder => new NonArchiveSqlFilterVisitor(b)
    case b: DeploymentsSqlBuilder => new DeploymentsSqlBuilderVisitor(b)
    case b: SelectArchivedPhasesBuilder => new SelectArchivedPhasesBuilderVisitor(b)
    case b: SelectArchivedReleasesBuilder => new SelectArchivedReleasesBuilderVisitor(b)
    case b: SelectArchivedTasksBuilder => new SelectArchivedTasksBuilderVisitor(b)
    case _ => throw new IllegalStateException(s"unable to perform filtering on this builder: [${builder.getClass.getName}]")
  }
}

abstract class UdmReportFilterSqlBuilderVisitor[T <: SqlBuilder[T]](val builder: T) extends UdmReportFilterVisitor[Unit] {
  override def visit(filter: CompositeFilter): Unit = {
    if (filter.getFilters != null && !filter.getFilters.isEmpty) {
      val childBuilder = builder.newInstance
      val childBuilderVisitor = wrap(childBuilder)
      filter.getFilters.forEach {
        case udmChildFilter: UdmReportFilter => udmChildFilter.accept(childBuilderVisitor)
        case _ => throw new IllegalStateException("Only Udm filters here")
      }
      val conditions = childBuilder.getConditions
      builder.withConditions(Seq(conditions: _*), filter.getOperator.getValue)
      childBuilder.getJoins.foreach(builder.addJoin)
    }
  }
  def wrap(builder: T): UdmReportFilterSqlBuilderVisitor[T]
}
