package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

import java.util.Objects;

@Metadata(label = "FolderFilter", versioned = false)
public class FolderFilter extends SimpleFilter {
    @Property(description = "The ID of the folder to filter.")
    private String folderId = "";

    public FolderFilter() {
    }

    public FolderFilter(String folderId) {
        this.folderId = folderId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final FolderFilter that = (FolderFilter) o;
        return Objects.equals(folderId, that.folderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), folderId);
    }

    @Override
    public String toString() {
        return "FolderFilter[folderId = " + folderId + "]";
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }
}
